(function(){
  function qs(sel, root){ return (root||document).querySelector(sel); }
  function qsa(sel, root){ return Array.prototype.slice.call((root||document).querySelectorAll(sel)); }

  function toggleGatewayPanels(){
    var sel = qs('#avasms_gateway_active');
    if(!sel) return;
    var active = sel.value;
    qsa('[data-avasms-gateway-panel]').forEach(function(p){
      p.style.display = (p.getAttribute('data-avasms-gateway-panel') === active) ? 'block' : 'none';
    });
  }

  function setStatus(text, ok){
    var el = qs('#avasms_test_result');
    if(el) el.textContent = text;
    var dot = qs('.avasms-status .avasms-dot');
    if(dot) dot.style.background = ok ? '#22c55e' : '#ef4444';
  }

  document.addEventListener('DOMContentLoaded', function(){
    var sel = qs('#avasms_gateway_active');
    if(sel){
      sel.addEventListener('change', toggleGatewayPanels);
      toggleGatewayPanels();
    }

    var btn = qs('#avasms_test_btn');
    if(btn){
      btn.addEventListener('click', function(e){
        e.preventDefault();
        var phone = (qs('#avasms_test_phone')||{}).value || '';
        var nonce = btn.getAttribute('data-nonce');
        setStatus('در حال ارسال...', true);

        var fd = new FormData();
        fd.append('action','avasms_test_sms');
        fd.append('nonce', nonce);
        fd.append('phone', phone);

        var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
        fetch(url, { method:'POST', credentials:'same-origin', body: fd })
          .then(function(r){ return r.json(); })
          .then(function(res){
            if(res && res.success){
              setStatus((res.data && res.data.message) ? res.data.message : 'موفق', true);
            }else{
              setStatus((res && res.data && res.data.message) ? res.data.message : 'ناموفق', false);
            }
          })
          .catch(function(){
            setStatus('خطا در ارتباط با سرور', false);
          });
      });
    }
  });
})();


// Single SMS page
(function(){
  function qs(sel, root){ return (root||document).querySelector(sel); }

  function setSingleStatus(text, ok){
    var el = qs('#avasms_single_result');
    if(el) el.textContent = text;
    var dot = qs('#avasms_single_result') ? qs('#avasms_single_result').parentElement.querySelector('.avasms-dot') : null;
    if(dot) dot.style.background = ok ? '#22c55e' : '#ef4444';
  }

  document.addEventListener('DOMContentLoaded', function(){
    var userSel = qs('#avasms_single_user');
    var phoneInp = qs('#avasms_single_phone');
    if(userSel && phoneInp){
      userSel.addEventListener('change', function(){
        var opt = userSel.options[userSel.selectedIndex];
        var ph = opt ? opt.getAttribute('data-phone') : '';
        if(ph) phoneInp.value = ph;
      });
    }

    var btn = qs('#avasms_single_send');
    if(btn){
      btn.addEventListener('click', function(e){
        e.preventDefault();
        var phone = (qs('#avasms_single_phone')||{}).value || '';
        var msg   = (qs('#avasms_single_message')||{}).value || '';
        var nonce = btn.getAttribute('data-nonce');
        setSingleStatus('در حال ارسال...', true);

        var fd = new FormData();
        fd.append('action','avasms_send_single');
        fd.append('nonce', nonce);
        fd.append('phone', phone);
        fd.append('message', msg);

        var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
        fetch(url, { method:'POST', credentials:'same-origin', body: fd })
          .then(function(r){ return r.json(); })
          .then(function(res){
            if(res && res.success){
              setSingleStatus((res.data && res.data.message) ? res.data.message : 'موفق', true);
            }else{
              setSingleStatus((res && res.data && res.data.message) ? res.data.message : 'ناموفق', false);
            }
          })
          .catch(function(){
            setSingleStatus('خطا در ارتباط با سرور', false);
          });
      });
    }
  });

  // Campaign builder
  var btnSave = qs('#avasms_c_save');
  if(btnSave){
    btnSave.addEventListener('click', function(){
      var nonce = qs('#avasms_campaign_nonce').value;
      var title = qs('#avasms_c_title').value || '';
      var message = qs('#avasms_c_message').value || '';
      var type = qs('#avasms_c_type').value || 'manual_list';
      var scheduled = qs('#avasms_c_schedule').value || '';
      var meta = {};

      if(type === 'roles'){
        meta.roles = qsa('#avasms_c_roles option:checked').map(function(o){ return o.value; });
      }else if(type === 'manual_list'){
        meta.numbers = qs('#avasms_c_numbers').value || '';
      }else if(type === 'excel'){
        try { meta.rows = JSON.parse((qs('#avasms_c_csv_rows')||{value:'[]'}).value || '[]'); } catch(e){ meta.rows=[]; }
      }

      var fd = new FormData();
      fd.append('action','avasms_save_campaign');
      fd.append('nonce', nonce);
      fd.append('title', title);
      fd.append('message', message);
      fd.append('audience_type', type);
      fd.append('audience_meta', JSON.stringify(meta));
      fd.append('scheduled_at', scheduled);

      var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
      fetch(url, { method:'POST', credentials:'same-origin', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(res){
          var out = qs('#avasms_c_save_result');
          if(!out) return;
          if(res && res.success){
            out.textContent = (res.data && res.data.message) ? res.data.message + ' (ID: ' + res.data.id + ')' : 'ذخیره شد';
          }else{
            out.textContent = (res && res.data && res.data.message) ? res.data.message : 'خطا در ذخیره';
          }
        })
        .catch(function(){
          var out = qs('#avasms_c_save_result');
          if(out) out.textContent = 'خطا در ارتباط با سرور';
        });
    });

    // Audience panels toggle
    var typeSel = qs('#avasms_c_type');
    var togglePanels = function(){
      var t = typeSel.value;
      qsa('.avasms-c-panel').forEach(function(tr){
        tr.style.display = (tr.getAttribute('data-panel') === t) ? '' : 'none';
      });
    };
    if(typeSel){
      typeSel.addEventListener('change', togglePanels);
      togglePanels();
    }

    // CSV upload
    var btnCsv = qs('#avasms_c_upload_csv');
    if(btnCsv){
      btnCsv.addEventListener('click', function(){
        var file = qs('#avasms_c_csv').files[0];
        if(!file){ alert('فایل CSV را انتخاب کنید.'); return; }
        var nonce = qs('#avasms_campaign_nonce').value;

        var fd = new FormData();
        fd.append('action','avasms_upload_campaign_csv');
        fd.append('nonce', nonce);
        fd.append('file', file);

        var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
        fetch(url, { method:'POST', credentials:'same-origin', body: fd })
          .then(function(r){ return r.json(); })
          .then(function(res){
            var preview = qs('#avasms_csv_preview');
            if(!preview) return;

            if(res && res.success){
              var rows = (res.data && res.data.rows) ? res.data.rows : [];
              var p = (res.data && res.data.preview) ? res.data.preview : [];

              // store full rows in hidden field
              var hidden = qs('#avasms_c_csv_rows');
              if(!hidden){
                hidden = document.createElement('input');
                hidden.type='hidden';
                hidden.id='avasms_c_csv_rows';
                preview.parentNode.appendChild(hidden);
              }
              hidden.value = JSON.stringify(rows);

              var html = '<div class="notice notice-success" style="padding:10px;"><p>تعداد رکورد: '+rows.length+'</p>';
              if(p.length){
                html += '<table class="widefat striped"><thead><tr><th>mobile</th><th>name</th></tr></thead><tbody>';
                p.forEach(function(r){
                  html += '<tr><td>'+ (r.mobile||'') +'</td><td>'+ (r.name||'') +'</td></tr>';
                });
                html += '</tbody></table>';
              }
              html += '</div>';
              preview.innerHTML = html;
            }else{
              preview.innerHTML = '<div class="notice notice-error" style="padding:10px;"><p>' + ((res && res.data && res.data.message) ? res.data.message : 'خطا') + '</p></div>';
            }
          })
          .catch(function(){
            var preview = qs('#avasms_csv_preview');
            if(preview) preview.innerHTML = '<div class="notice notice-error" style="padding:10px;"><p>خطا در ارتباط با سرور</p></div>';
          });
      });
    }
  }

  // Campaign list actions
  qsa('.avasms-c-prepare').forEach(function(btn){
    btn.addEventListener('click', function(){
      var id = btn.getAttribute('data-id');
      var nonce = (qs('#avasms_campaign_nonce')||{value:''}).value;
      var fd = new FormData();
      fd.append('action','avasms_prepare_campaign');
      fd.append('nonce', nonce);
      fd.append('id', id);

      var box = qs('#avasms_c_prog_'+id);
      if(box) box.textContent = 'در حال آماده‌سازی...';

      var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
      fetch(url, { method:'POST', credentials:'same-origin', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(res){
          if(box){
            box.textContent = (res && res.success) ? ('Queued: ' + (res.data.queued||0)) : ((res && res.data && res.data.message) ? res.data.message : 'خطا');
          }
        });
    });
  });

  qsa('.avasms-c-send').forEach(function(btn){
    btn.addEventListener('click', function(){
      var id = btn.getAttribute('data-id');
      var nonce = (qs('#avasms_campaign_nonce')||{value:''}).value;

      var fd = new FormData();
      fd.append('action','avasms_send_campaign_batch');
      fd.append('nonce', nonce);
      fd.append('id', id);

      var box = qs('#avasms_c_prog_'+id);
      if(box) box.textContent = 'در حال ارسال...';

      var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
      fetch(url, { method:'POST', credentials:'same-origin', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(res){
          if(!box) return;
          if(res && res.success){
            var s = res.data.stats || {};
            box.textContent = 'Sent now: '+(res.data.sent_now||0)+' | pending: '+(s.pending||0)+' | sent: '+(s.sent||0)+' | failed: '+(s.failed||0);
          }else{
            box.textContent = (res && res.data && res.data.message) ? res.data.message : 'خطا';
          }
        });
    });
  });

  qsa('.avasms-c-delete').forEach(function(btn){
    btn.addEventListener('click', function(){
      if(!confirm('حذف کمپین و صف ارسال؟')) return;
      var id = btn.getAttribute('data-id');
      var nonce = (qs('#avasms_campaign_nonce')||{value:''}).value;

      var fd = new FormData();
      fd.append('action','avasms_delete_campaign');
      fd.append('nonce', nonce);
      fd.append('id', id);

      var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
      fetch(url, { method:'POST', credentials:'same-origin', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(res){
          if(res && res.success){
            location.reload();
          }else{
            alert((res && res.data && res.data.message) ? res.data.message : 'خطا');
          }
        });
    });
  });

  // Logs cleanup
  var btnClear = qs('#avasms_clear_logs');
  if(btnClear){
    btnClear.addEventListener('click', function(){
      var nonce = btnClear.getAttribute('data-nonce');
      var fd = new FormData();
      fd.append('action','avasms_clear_logs');
      fd.append('nonce', nonce);
      fd.append('days', 30);

      var out = qs('#avasms_clear_logs_result');
      if(out) out.textContent = 'در حال پاکسازی...';

      var url = (window.AvaSMSAdmin && AvaSMSAdmin.ajaxUrl) ? AvaSMSAdmin.ajaxUrl : (window.ajaxurl || '');
      fetch(url, { method:'POST', credentials:'same-origin', body: fd })
        .then(function(r){ return r.json(); })
        .then(function(res){
          if(out){
            out.textContent = (res && res.success) ? (res.data.message||'انجام شد') : ((res && res.data && res.data.message) ? res.data.message : 'خطا');
          }
          if(res && res.success) setTimeout(function(){ location.reload(); }, 800);
        });
    });
  }
})();
