<?php
namespace Avayemarketing\AvaSMS\Elementor;

if (!defined('ABSPATH')) exit;

final class ElementorModule
{
    /**
     * Prevent double registration (some Elementor versions fire both hooks).
     * Double registration can break Elementor editor (infinite loading).
     */
    private static bool $did_register = false;

    public function register_hooks(): void
    {
        add_action('elementor/init', [$this, 'on_init']);
    }

    public function on_init(): void
    {
        // Only run if Elementor is loaded
        if (!did_action('elementor/loaded')) return;

        // Register widgets once, compatible across Elementor versions.
        add_action('elementor/widgets/register', [$this, 'register_widgets'], 10, 1);
        add_action('elementor/widgets/widgets_registered', [$this, 'register_widgets_legacy'], 10, 0);
    }

    public function register_widgets($widgets_manager): void
    {
        if (self::$did_register) return;
        if (!class_exists(AvaSMS_Login_Register_Widget::class)) return;
        // Elementor 3.5+
        if (method_exists($widgets_manager, 'register')) {
            $widgets_manager->register(new AvaSMS_Login_Register_Widget());
        } elseif (method_exists($widgets_manager, 'register_widget_type')) {
            // Legacy
            $widgets_manager->register_widget_type(new AvaSMS_Login_Register_Widget());
        }
        self::$did_register = true;
    }

    public function register_widgets_legacy(): void
    {
        if (self::$did_register) return;
        if (!class_exists('\Elementor\Plugin')) return;
        $widgets_manager = \Elementor\Plugin::instance()->widgets_manager;
        $this->register_widgets($widgets_manager);
    }
}
