<?php
namespace Avayemarketing\AvaSMS\SMS\Gateways;

if (!defined('ABSPATH')) exit;

/**
 * IPPANEL gateway (skeleton)
 * NOTE: Adjust endpoint/params based on your IPPANEL API docs.
 */
final class IppanelGateway extends AbstractGateway
{
    public function key(): string { return 'ippanel'; }

    public function is_configured(): bool
    {
        return !empty($this->settings['api_key']) && !empty($this->settings['sender_line']);
    }

    public function send(string $to, string $message, array $args = []): array
    {
        $api_key = (string)($this->settings['api_key'] ?? '');
        $sender  = (string)($this->settings['sender_line'] ?? '');

        // Example endpoint (may differ):
        // https://api2.ippanel.com/api/v1/sms/send/webservice/single
        $endpoint = (string)($this->settings['endpoint'] ?? 'https://api2.ippanel.com/api/v1/sms/send/webservice/single');

        $headers = [
            'Content-Type'  => 'application/json',
            'Authorization' => 'AccessKey ' . $api_key,
        ];

        $payload = [
            'sender'   => $sender,
            'recipient'=> [$to],
            'message'  => $message,
        ];

        $resp = wp_remote_post($endpoint, [
            'timeout' => 15,
            'headers' => $headers,
            'body'    => wp_json_encode($payload),
        ]);

        if (is_wp_error($resp)) {
            return [
                'success' => false,
                'message' => 'خطا در ارتباط با IPPANEL',
                'provider_response' => $resp->get_error_message(),
                'error_code' => 'wp_error',
            ];
        }

        $code = (int)wp_remote_retrieve_response_code($resp);
        $raw  = wp_remote_retrieve_body($resp);

        if ($code < 200 || $code >= 300) {
            return [
                'success' => false,
                'message' => 'ارسال از طریق IPPANEL ناموفق بود.',
                'provider_response' => $raw,
                'error_code' => (string)$code,
            ];
        }

        return [
            'success' => true,
            'message' => 'ارسال با موفقیت انجام شد.',
            'provider_response' => $raw,
            'error_code' => null,
        ];
    }
}
