#{{uc_id}}{
  width:100%;
  position:relative;
  overflow:hidden;
  display:flex;
  flex-direction:column;
  justify-content: center;
  align-items: center;
  min-height: fit-content;
}
#{{uc_id}} .sbh_bg_overlay{
  position:absolute;
  top:0;
  left:0;
  width:100%;
  height:100%;
  overflow:hidden;
}
#{{uc_id}} .uc_container_holder,
#{{uc_id}} .ue_sbh_divider,
#{{uc_id}} .uc_container_holder_top,
#{{uc_id}} .uc_container_holder_bottom{
  position:relative;
}
#{{uc_id}} .uc_container_holder{
  display: flex;
  flex-direction: column;
}
#{{uc_id}} .uc_logo{
  display:inline-flex;
  justify-content:center;
  align-items:center;
}
#{{uc_id}} .uc_logo svg{
  width:1em;
  height:1em;
}
#{{uc_id}} .uc_container_holder{
  width:100%;
}
#{{uc_id}} .uc_portfolio{
  display:inline-block;
  transition-duration:300ms;
}
#{{uc_id}} .uc_container_holder_bottom{
  display:flex;
  flex-wrap: wrap;
  gap:{{sb_gap}};
}
#{{uc_id}} .uc_footer_box{
  width:calc({{100 / service_columns}}% - {{sb_gap|default("0px")}} + ({{sb_gap|default("0px")}} / {{service_columns}}));
}
#{{uc_id}} .uc_container_holder_bottom .uc_footer_box{
  {% if auto_stretch == "true" %}flex-grow: 1; {% endif %}
  display:block;
}
@media (max-width: 1024px) {
  #{{uc_id}} .uc_container_holder_bottom{
    gap:{{sb_gap_tablet}};
  }
  #{{uc_id}} .uc_footer_box{
    width:calc({{100 / service_columns_tablet}}% - {{sb_gap_tablet|default("0px")}} + ({{sb_gap_tablet|default("0px")}} / {{service_columns_tablet}}));
  }
}
@media (max-width: 767px) {
  #{{uc_id}} .uc_container_holder_bottom{
    gap:{{sb_gap_mobile}};
  }
  #{{uc_id}} .uc_footer_box{
    width:calc({{100 / service_columns_mobile}}% - {{sb_gap_mobile|default("0px")}} + ({{sb_gap_mobile|default("0px")}} / {{service_columns_mobile}}));
  }
}
/* soft styles */
.uc_cont_paragrapgh{
  font-size:18px;
  font-weight:400;
  line-height:1.4em;
}
.uc_paragraph{
  font-size: 16px;
  font-weight: 400;
}
.uc_service_title{
  font-size: 22px;
  font-weight:500;
}
.elementor-widget-ucaddon_service_box_hero{
  width:100%;
}