#{{uc_id}}{
  min-height:1px;
}
#{{uc_id}} .eu-item-box{
  overflow:hidden;
  margin-left:auto;
  margin-right:auto;
  line-height: 0;
}
#{{uc_id}} *{
  transition: all 300ms;
}
#{{uc_id}} .eu-item-thumb{
  overflow:hidden;
  background-image:url({{image}});
  transition: background-position {{scroll_duration}}s;
  background-size:cover;
  position: relative;
}
{% if scroll_direction == "top-bottom" %}
#{{uc_id}} .eu-item-thumb{ background-position:top center; }
#{{uc_id}}:{{trigger}} .eu-item-thumb{ background-position:bottom center; }
{% endif %}

{% if scroll_direction == "bottom-top" %}
#{{uc_id}} .eu-item-thumb{ background-position:bottom center; }
#{{uc_id}}:{{trigger}} .eu-item-thumb{ background-position:top center; }
{% endif %}

{% if scroll_direction == "left-right" %}
#{{uc_id}} .eu-item-thumb{ background-position:center left; }
#{{uc_id}}:{{trigger}} .eu-item-thumb{ background-position:center right; }
{% endif %}

{% if scroll_direction == "right-left" %}
#{{uc_id}} .eu-item-thumb{ background-position:center right; }
#{{uc_id}}:{{trigger}} .eu-item-thumb{ background-position:center left; }
{% endif %}

#{{uc_id}} .eu-item-content-title
{
  font-size:21px;
}
#{{uc_id}} .device-image-top, .device-image-bottom{
  width:100%;
  height: auto;
  margin-bottom: -0.05em;
}
{% if device_type != "none" %}
#{{uc_id}} .thumb-wrapper{ background-color: #464648;}
{% endif %}


{% if show_overlay == "true" %} 
#{{uc_id}} .ue_image_scroll_overlay{
  width:100%;
  height:100%;
  display:flex;
  justify-content: center;
  align-items: center;
}
#{{uc_id}}:{{trigger}} .ue_image_scroll_overlay{
  opacity:0%;
}
{% endif %}
{% if show_overlay_icon == "true" %}
#{{uc_id}} .ue_image_scroll_overlay_icon{
  opacity:1;
  position:absolute;
  top:50%;
  left:50%;
  transform:translate(-50%, -50%);
}
#{{uc_id}}:{{trigger}} .ue_image_scroll_overlay_icon{
  opacity:0;
}
#{{uc_id}} .ue_image_scroll_overlay_icon svg{
  width:1em;
  height:1em;
}
{% if icon_animation == "true" %}
#{{uc_id}} .ue_image_scroll_overlay_icon i, #{{uc_id}} .ue_image_scroll_overlay_icon svg{  
    {% if scroll_direction in ["top-bottom", "bottom-top"] %} animation-name: ue_icon_floating-a; {% endif %}
    {% if scroll_direction in ["left-right", "right-left"] %} animation-name: ue_icon_floating-b; {% endif %}
    animation-duration: 2s;
    animation-iteration-count: infinite;
    animation-timing-function: ease-in-out;
  }
  {% if scroll_direction in ["top-bottom", "bottom-top"] %}
  @keyframes ue_icon_floating-a {
    from { transform: translate(0,  -4px); }
    50%  { transform: translate(0, 4px); }
    to   { transform: translate(0, -4px); }    
  }
  {% endif %}
  {% if scroll_direction in ["left-right", "right-left"] %}
  @keyframes ue_icon_floating-b {
    from { transform: translate(-4px,  0); }
    50%  { transform: translate(4px, 0); }
    to   { transform: translate(-4px, 0); }    
  }
  {% endif %}
{% endif %}
{% endif %}