#{{uc_id}} {
  position: relative;
  display: block;
  overflow:hidden;
  width:100%;
}
#{{uc_id}} .ue-hover-image-video{
  position: relative;
  overflow:hidden;
  background:url("{{image}}");
  background-size:cover;
}

#{{uc_id}} .ue-image{
  display: block;
  width:100%;
  position: relative;
  z-index: 2;
}
#{{uc_id}} .ue-video{
  display: block;
  object-fit: cover;
  width:100%;
  position: absolute;
  top: 0;
  left: 0;
  z-index: 1;
}

{% if show_overlay == "true" %}
#{{uc_id}} .ue-overlay{
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 3; 
  pointer-events: none;
  {% if show_overlay_on == "all" %}display:flex;{% else %}display:none;{% endif %}
  justify-content:center;
  align-items:center;
}
{% if show_overlay_on == "touch" %}
#{{uc_id}}.touch-device .ue-overlay{
  display:flex!important;
}
{% endif %}
{% if show_overlay_on == "touch" %}
#{{uc_id}}.touch-device .ue-overlay{
  display:flex!important;
}
{% endif %}
{% if show_overlay_on == "desktop" %}
#{{uc_id}}:not(.touch-device) .ue-overlay {
  display: flex !important;
}
{% endif %}
  {% if show_overlay_icon == "true" %}
  #{{uc_id}} .ue-overlay-icon{
    display:flex;
    justify-content:center;
    align-items:center;
    position:relative;
    opacity:1;
  }
  #{{uc_id}}.ue-video-playing .ue-overlay-icon{
    opacity:0;
  }
  #{{uc_id}} .ue-overlay-icon svg{
    width:1em;
    height:1em;
  }
    {% if show_icon_ripple_effect == "true" %}
    #{{uc_id}} .ue-overlay-icon:before{
      content: '';
      display: inline-block;
      position: absolute;
      top: -2px;
      left: -2px;
      bottom: -2px;
      right: -2px;
      border-radius: inherit;
      border-width:1px;
      border-style:solid;
      -webkit-animation: btnIconRipple 2s cubic-bezier(0.23, 1, 0.32, 1) both infinite;
      animation: btnIconRipple 2s cubic-bezier(0.23, 1, 0.32, 1) both infinite;
    }
    @keyframes btnIconRipple {
      0% {
        border-width: 4px;
            transform: scale(1);
      }
      80% {
      border-width: 1px;
            transform: scale(1.35);
      }
      100% {
        opacity: 0;
      }
    }
    {% endif %}
  {% endif %}
{% endif %}

{% if show_button == "true" %}
 #{{uc_id}} .ue-button{
  display:flex;
  justify-content:center;
  align-items:center;
  position: absolute;
  z-index: 4;
  opacity:0;
  pointer-events:none;
 }
 #{{uc_id}}.ue-video-playing .ue-button{
  opacity:1;
  pointer-events:all;
  transition: all 0.3s ease-in-out; 
 }
 {% if show_button_icon == "true" %}
  #{{uc_id}} .ue-button svg{
    width:1em;
    height:1em;
  }
 {% endif %}

 /* Mobile - up to 767px */
 @media (max-width: 767px) {
   #{{uc_id}} .ue-button{
    {% if button_position_mobile == "center_center" %}
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    {% endif %}
    {% if button_position_mobile == "bottom_center" %}
      left: 50%;
      transform: translateX(-50%);
      bottom:{{button_gap_mobile}};
    {% endif %}
    {% if button_position_mobile == "top_left" %}
      left:{{button_gap_side_mobile}};
      top:{{button_gap_mobile}};
    {% endif %}
    {% if button_position_mobile == "top_right" %}
      right:{{button_gap_side_mobile}};
      top:{{button_gap_mobile}};
    {% endif %}
    {% if button_position_mobile == "bottom_left" %}
      left:{{button_gap_side_mobile}};
      bottom:{{button_gap_mobile}};
    {% endif %}
    {% if button_position_mobile == "bottom_right" %}
      right:{{button_gap_side_mobile}};
      bottom:{{button_gap_mobile}};
    {% endif %}
   }
 }
 @media (min-width: 768px) and (max-width: 1023px) {
   #{{uc_id}} .ue-button{
    {% if button_position_tablet == "center_center" %}
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    {% endif %}
    {% if button_position_tablet == "bottom_center" %}
      left: 50%;
      transform: translateX(-50%);
      bottom:{{button_gap_tablet}};
    {% endif %}
    {% if button_position_tablet == "top_left" %}
      left:{{button_gap_side_tablet}};
      top:{{button_gap_tablet}};
    {% endif %}
    {% if button_position_tablet == "top_right" %}
      right:{{button_gap_side_tablet}};
      top:{{button_gap_tablet}};
    {% endif %}
    {% if button_position_tablet == "bottom_left" %}
      left:{{button_gap_side_tablet}};
      bottom:{{button_gap_tablet}};
    {% endif %}
    {% if button_position_tablet == "bottom_right" %}
      right:{{button_gap_side_tablet}};
      bottom:{{button_gap_tablet}};
    {% endif %}
   }
 }
 @media (min-width: 1024px) {
   #{{uc_id}} .ue-button{
    {% if button_position == "center_center" %}
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    {% endif %}
    {% if button_position == "bottom_center" %}
      left: 50%;
      transform: translateX(-50%);
      bottom:{{button_gap}};
    {% endif %}
    {% if button_position == "top_left" %}
      left:{{button_gap_side}};
      top:{{button_gap}};
    {% endif %}
    {% if button_position == "top_right" %}
      right:{{button_gap_side}};
      top:{{button_gap}};
    {% endif %}
    {% if button_position == "bottom_left" %}
      left:{{button_gap_side}};
      bottom:{{button_gap}};
    {% endif %}
    {% if button_position == "bottom_right" %}
      right:{{button_gap_side}};
      bottom:{{button_gap}};
    {% endif %}
   }
 }
{% endif %}