<?php
namespace Avayemarketing\AvaSMS;

if (!defined('ABSPATH')) exit;

final class Autoload
{
    public static function register(): void
    {
        spl_autoload_register([self::class, 'autoload'], true, true);
    }

    public static function autoload(string $class): void
    {
        $prefix = __NAMESPACE__ . '\\';
        if (strncmp($class, $prefix, strlen($prefix)) !== 0) return;

        $relative = substr($class, strlen($prefix));
        $relative = str_replace('\\', DIRECTORY_SEPARATOR, $relative);
        $file = AVASMS_PATH . 'includes' . DIRECTORY_SEPARATOR . $relative . '.php';

        if (is_readable($file)) require_once $file;
    }
}
