<?php
namespace Avayemarketing\AvaSMS\SMS\Gateways;

if (!defined('ABSPATH')) exit;

/**
 * FarazSMS gateway (skeleton)
 * NOTE: You must adjust endpoint/params for your FarazSMS panel.
 */
final class FarazSmsGateway extends AbstractGateway
{
    public function key(): string { return 'farazsms'; }

    public function is_configured(): bool
    {
        return !empty($this->settings['username']) && !empty($this->settings['password']);
    }

    public function send(string $to, string $message, array $args = []): array
    {
        $username = (string)($this->settings['username'] ?? '');
        $password = (string)($this->settings['password'] ?? '');
        $sender   = (string)($this->settings['sender_line'] ?? '');

        // Placeholder endpoint - replace with real one.
        $endpoint = (string)($this->settings['endpoint'] ?? '');

        if ($endpoint === '') {
            return [
                'success' => false,
                'message' => 'Endpoint درگاه فراز پیامک تنظیم نشده است.',
                'provider_response' => null,
                'error_code' => 'no_endpoint',
            ];
        }

        $body = [
            'username' => $username,
            'password' => $password,
            'to'       => $to,
            'text'     => $message,
        ];
        if ($sender !== '') $body['from'] = $sender;

        $r = $this->http_post($endpoint, $body);

        if (!$r['ok']) {
            return [
                'success' => false,
                'message' => 'ارسال از طریق فراز پیامک ناموفق بود.',
                'provider_response' => $r['raw'],
                'error_code' => $r['code'],
            ];
        }

        return [
            'success' => true,
            'message' => 'ارسال با موفقیت انجام شد.',
            'provider_response' => $r['raw'],
            'error_code' => null,
        ];
    }
}
