<?php
namespace Avayemarketing\AvaSMS\SMS\Gateways;

if (!defined('ABSPATH')) exit;

/**
 * Kavenegar gateway (skeleton)
 * NOTE: Adjust endpoint/params based on your Kavenegar account/API docs.
 */
final class KavenegarGateway extends AbstractGateway
{
    public function key(): string { return 'kavenegar'; }

    public function is_configured(): bool
    {
        return !empty($this->settings['api_key']);
    }

    public function send(string $to, string $message, array $args = []): array
    {
        $api_key = (string)($this->settings['api_key'] ?? '');
        $sender  = (string)($this->settings['sender_line'] ?? '');

        // Example endpoint:
        // https://api.kavenegar.com/v1/{API-KEY}/sms/send.json
        $endpoint = 'https://api.kavenegar.com/v1/' . rawurlencode($api_key) . '/sms/send.json';

        $body = [
            'receptor' => $to,
            'message'  => $message,
        ];
        if ($sender !== '') $body['sender'] = $sender;

        $r = $this->http_post($endpoint, $body);

        if (!$r['ok']) {
            return [
                'success' => false,
                'message' => 'ارسال از طریق کاوه‌نگار ناموفق بود.',
                'provider_response' => $r['raw'],
                'error_code' => $r['code'],
            ];
        }

        return [
            'success' => true,
            'message' => 'ارسال با موفقیت انجام شد.',
            'provider_response' => $r['raw'],
            'error_code' => null,
        ];
    }
}
