function ueSlidingMenu(){
  var g_backLinkClass, g_activeClass, g_hasChildrenClass, g_expandIconClass;
  var g_subMenuSelector, g_expandIconSelector;
  var g_objWidget, g_objItems, g_objExpand;
  var g_clickableParents;
  
  /**
  * append back links to submenus
  */
  function appendBackLinksToSubMenus(){   
    var objSubMenus = g_objWidget.find(g_subMenuSelector);
    
    if(!objSubMenus || objSubMenus.length == 0)
      return(false);
    
    var objBackLinkPlaceholder = g_objWidget.find(".ue-back-link");
    var backLinkInnerHtml = objBackLinkPlaceholder.html();  
    
    objSubMenus.each(function(){
      var objSubMenu = jQuery(this);
      var backLinkHtml = `<li class="${g_backLinkClass}"><a>${backLinkInnerHtml}</a></li>`;
      
      objSubMenu.prepend(backLinkHtml);
    });
  }
  
  /**
  * append append expand collapse icons
  */
  function appendExpandIcons(){   
    var objSubMenus = g_objWidget.find(g_subMenuSelector);
    
    if(!objSubMenus || objSubMenus.length == 0)
      return(false);
    
    var objExpandLinkPlaceholder = g_objWidget.find(".ue-slide-menu-expand-icon-placeholder");
    
    objSubMenus.each(function(){
      var objSubMenu = jQuery(this);
      var objSubMenuLink = objSubMenu.prev();
      
      objSubMenuLink.append(objExpandLinkPlaceholder.html());
    });
  }
  
  /**
  * set min height of the menu
  */
  function setMinHeight(){
    var objSubMenus = g_objWidget.find(g_subMenuSelector);
    
    if(!objSubMenus || objSubMenus.length == 0)
      return(false);
    
    var maxHeight = 0;
    
    objSubMenus.each(function(){
      var objSubMenu = jQuery(this);
      var subMenuHeight = objSubMenu.outerHeight(true);
      
      if(subMenuHeight > maxHeight)
        maxHeight = subMenuHeight;
      
    });
    
    var objMenuWrap = g_objWidget.find(".ue-slide-menu-wrapper");
    
    objMenuWrap.css("min-height", maxHeight+"px");
  }
  
  /**
  * init menu layout
  */
  function initMenuLayout(){
    var objSubMenus = g_objWidget.find(g_subMenuSelector);
    
    if(!objSubMenus || objSubMenus.length == 0)
      return(false);
    
    objSubMenus.each(function(){
      var objSubMenu = jQuery(this);
      var objParentLink = objSubMenu.prev();
      
      if(g_clickableParents == false)
        objParentLink.removeAttr("href");
      
    });
  }
  
  /** 
  * open submenu on link click
  */
  function openSubMenu(objLink){
    var objParentMenuItem = objLink.closest(`.${g_hasChildrenClass}`);
    
    if(!objParentMenuItem || objParentMenuItem.length == 0)
      return(true);
    
    var objSubMenu = objParentMenuItem.find(`>${g_subMenuSelector}`);
    
    if(!objSubMenu || objSubMenu.length == 0)
      return(true);
    
    var isLinkActive = objLink.hasClass(g_activeClass);
    
    if(isLinkActive == false){
      objLink.addClass(g_activeClass);
      objSubMenu.addClass(g_activeClass);
    }else{
      objLink.removeClass(g_activeClass);
      objSubMenu.removeClass(g_activeClass);
    }
  }
  
  /**
  * on expand Icon Click
  */
  function onExpandIconClick(e){ 
    var objIcon = jQuery(this);
    var objParentLink = objIcon.closest("a");

    e.stopPropagation();
    
    openSubMenu(objParentLink);
  }
  
  /**
  * on menu link click
  */
  function onMenuLinkClick(e){
    var objLink = jQuery(this);
    var objTarget = jQuery(e.target);
    var objParentExpand = objTarget.closest(g_expandIconSelector);
    
    if(g_clickableParents == true){
      var isTargetExpandIcon = objTarget.hasClass(g_expandIconClass);
      var isParentExpandIconExist = objParentExpand && objParentExpand.length > 0;
      
      if(isTargetExpandIcon == true || isParentExpandIconExist == true){
        e.preventDefault();

        openSubMenu(objLink);

        return(true);
      }else{
        //default behaviour - follow the link
      }

    }else    
    openSubMenu(objLink);
  }
  
  /**
  * on back link click
  */
  function onBackLinkClick(){
    var objBackLink = jQuery(this);
    var objParentSubMenu = objBackLink.closest(g_subMenuSelector);
    var objMenuLink = objParentSubMenu.prev();
    
    objParentSubMenu.removeClass(g_activeClass);
    objMenuLink.removeClass(g_activeClass);
  }
  
  /**
  * init menu
  */
  this.init = function(options){
    var widgetId = options.id;
    var menuSide = options.menuSide;
    
    g_menuOpenClass = `ue-slide-menu-fixed-${menuSide}--open`;
    g_menuCloseClass = `ue-slide-menu-fixed-${menuSide}--close`;
    g_backLinkClass = "ue-back-link";
    g_activeClass = "ue-active";
    g_hasChildrenClass = "menu-item-has-children";
    g_menuClass = "ue-slide-menu";
    g_expandIconClass = "ue-slide-menu-expand-icon";
    
    g_subMenuSelector = ".sub-menu";
    g_expandIconSelector = "."+g_expandIconClass;
    
    g_objWidget = jQuery(`#${widgetId}`);
    g_objOpenMenu = g_objWidget.find(".ue-slide-menu-open");
    g_objCloseMenu = g_objWidget.find(".ue-slide-menu-close");
    g_objFixed = g_objWidget.find(".ue-slide-menu-fixed");
    g_objItems = g_objWidget.find(".menu-item>a");
    g_objExpand = g_objWidget.find(g_expandIconSelector);
    
    g_slidingTransition = "fast";
    g_clickableParents = options.clickableParents;
    g_closeOnBody = options.closeOnBody;
    
    //init view
    initMenuLayout();
    
    //append back links
    appendBackLinksToSubMenus();
    
    //append exp / coll icons
    appendExpandIcons();
    
    //set min height
    setMinHeight();
    
    //init events
    g_objItems.on("click", onMenuLinkClick);
    jQuery(`.${g_backLinkClass}`).on("click", onBackLinkClick);
  }
}