{{ ucfunc("put_docready_start") }}
		
  var objImgAccordion = jQuery("#{{uc_id}}");
  var objItems = objImgAccordion.find(".uc_image_accodion_holder");
  var objImgAccordionContent = objImgAccordion.find('.uc_content');
  var hoverClass = "uc_hover";
  var mobileStart = objImgAccordion.data("mobilestart");
  var isMobile = window.matchMedia("(max-width: 767px)").matches;

  /**
  * deactivate all items
  */
  function deactivateAllItems(){
    objItems.removeClass(hoverClass);          
    objItems.attr("aria-expanded", false);
  }

  /**
  * activate item
  */
  function activateItem(objItem){
    deactivateAllItems();    
    
    objItem.addClass(hoverClass);          
    objItem.attr("aria-expanded", true);
  }

  /**
  * on keydown
  */
  function onKeydown(e, objItem){
    var keyCode = e.keyCode;
    
    //enter
    if(keyCode == 13)        
      activateItem(objItem);
    
    //esc
    if(keyCode == 27)        
      deactivateAllItems();
  }
  
  /**
  * init image accordion
  */
  function initImageAccordion(){    
    
    if(isMobile == true && mobileStart && jQuery.isNumeric(mobileStart)){
      jQuery(objItems[mobileStart-1]).addClass(hoverClass);
    }    
  
    {% if (event == "hover") %}
    
        objItems.on('mouseenter', function(){
          var objItem = jQuery(this);
          
          activateItem(objItem);
        });
     
        objItems.on('mouseleave', function(){
          deactivateAllItems();
        });
     
    {% endif %}

    objItems.on('click', function(event){	  	  
	  var objItem = jQuery(this);
      
      activateItem(objItem);	  
	  
	  var link = objItem.attr("href");
      
	  if(link == "#")
		event.preventDefault();	  	  
	});  
     
    objItems.on("keydown", function(e){
      var objItem = jQuery(this);
      
      onKeydown(e, objItem);
    });
  }
  
  //init image accordion   
  initImageAccordion();
     
  //init events   
  objImgAccordion.on("uc_ajax_refreshed",function(){
    initImageAccordion();     
  });
 
  var objRemoteOptions = {
    	class_items:"uc_image_accodion_holder",
    	class_active:"uc_hover",
    	selector_item_trigger:".uc_overlay"
  };
 
  {{ucfunc("put_remote_parent_js","objImgAccordion","objRemoteOptions")}}
    	
{{ ucfunc("put_docready_end") }}