{{ ucfunc("put_docready_start") }}

  var objSwitcher = jQuery('#{{uc_id}}');

  function initSwitcher(){

    var objSwitcherCols = objSwitcher.find('.uc_hover_switcher_col');
    var objSwitcherRemoteItems = objSwitcher.find(".uc_hover_remote_item");
    var classActive = 'uc_hover';
    var isFirstSelected = objSwitcher.data('first-selected');
    var firstObjSwitcherCol = objSwitcherCols.eq({{first_selected_num}});      
    var firstObjSwitcherRemoteItem = objSwitcherRemoteItems.eq({{first_selected_num}});

    if(isFirstSelected == true){      
      firstObjSwitcherCol.addClass(classActive);
      firstObjSwitcherCol.attr("aria-selected", true);
      
      firstObjSwitcherRemoteItem.addClass(classActive);
    }        

    function setActiveItem(objSwitcherCol, objSwitcherRemoteItem){
      objSwitcherCols.removeClass(classActive);
      objSwitcherCols.attr("aria-selected", false);
      
      objSwitcherCol.addClass(classActive);
      objSwitcherCol.attr("aria-selected", true);

      objSwitcherRemoteItems.removeClass(classActive);
      objSwitcherRemoteItem.addClass(classActive);
    }

    function onMouseEnter(){
      var objSwitcherCol = jQuery(this);
      var currentItemIndex = Math.floor(objSwitcherCol.index() / 2);
      var objSwitcherRemoteItem = objSwitcherRemoteItems.eq(currentItemIndex);

      setActiveItem(objSwitcherCol, objSwitcherRemoteItem);

      objSwitcherCol.trigger("click");
      objSwitcherRemoteItem.trigger("click"); 
    }
    
    function onKeydown(e){
      var key = e.code || e.keyCode;
      var objTarget = jQuery(e.target);
      
      if(key == "Enter" || key == 13){      
        var objSwitcherCol = objTarget;
        var currentItemIndex = Math.floor(objSwitcherCol.index() / 2);
		var objSwitcherRemoteItem = objSwitcherRemoteItems.eq(currentItemIndex);
        
        setActiveItem(objSwitcherCol, objSwitcherRemoteItem);
      }
      
      if(key == "Escape" || key == 27){
        objSwitcherCols.removeClass(classActive);
        objSwitcherCols.attr("aria-selected", false);
        objSwitcherRemoteItems.removeClass(classActive);
      }
    }

    function onMouseClick(){
      var objSwitcherRemoteItem = jQuery(this);
      var currentItemIndex = objSwitcherRemoteItem.index();
      var objSwitcherCol = objSwitcherCols.eq(currentItemIndex);

      setActiveItem(objSwitcherCol, objSwitcherRemoteItem);
    }

    objSwitcherCols.on('mouseenter', onMouseEnter);
    objSwitcherRemoteItems.on('click', onMouseClick);
    objSwitcherCols.on('keydown', function(e){onKeydown(e)});
  }      

  initSwitcher();

  objSwitcher.on("uc_ajax_refreshed",function(){      
    initSwitcher();      
  }); 

  var objRemoteOptions = {
    class_items:"uc_hover_remote_item",
    class_active:"uc_hover",
    selector_item_trigger:".uc_hover_remote_segment"
  };

  {{ucfunc("put_remote_parent_js","objSwitcher","objRemoteOptions")}}
    	
{{ ucfunc("put_docready_end") }}