#{{uc_id}}
{
  display:flex;
}

#{{uc_id}} .ue-link
{
  display:block;
  position:absolute;
  top:0px;
  bottom:0px;
  left:0px;
  right:0px;
}

#{{uc_id}} .ue-step-item
{
  flex:1;
  display:flex;
  flex-direction:column;
  position:relative;
}
#{{uc_id}} .ue-item-highlight
{
  display: flex;
  align-items:center;
  
}

#{{uc_id}} .ue-step-item-gap
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-step-item-line
{
  height:{{line_width}}px;
  flex-grow:1;
}

#{{uc_id}} .ue-step-icon
{
  display:flex;
  justify-content:center;
  align-items:center;
  flex-grow:0;
  flex-shrink:0;
  position:relative;
  line-height:1em;
  transition:0.3s;
}

#{{uc_id}} .ue-icon svg
{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue-step-label
{
  position:absolute;
  {{label_x_position}}:{{x_space}}px;
  {{label_y_position}}:{{y_space}}px;
  display:flex;
  justify-content:center;
  align-items:center;
}
.ue-step-label
{
  font-size:9px;
  line-height:1em;
}

#{{uc_id}} .ue-step-item-content
{
}

#{{uc_id}} .ue-step-item:last-child .ue-step-item-line:last-child
{
  opacity:0;
}

#{{uc_id}} .ue-step-item:first-child .ue-step-item-line:first-child
{
  opacity:0;
}

#{{uc_id}} .ue-step-item-spacer
{
  flex-grow:0;
  flex-shrink:0;
  
}

#{{uc_id}} .ue-graphic-image img
{
  
}


#{{uc_id}}.uc-remote-parent .ue-step-item
{
  cursor:pointer;
}


{% if layout == "vertical" %}

	#{{uc_id}}
    {
      flex-direction:column;
    }
  
  #{{uc_id}} .ue-step-item
  {
    flex-direction:row;
  }
  
  #{{uc_id}} .ue-item-highlight
  {
    flex-direction:column;
  }
  
   #{{uc_id}} .ue-step-item .ue-step-item-line:first-child
    {
      display:none;
    }
  

    #{{uc_id}}  .ue-step-item-gap:nth-child(2)
     {
      display:none;    
      }
   #{{uc_id}}  .ue-step-item-line:first-child
      {
      display:none;    
      }
  
    #{{uc_id}}  .ue-step-item-line
      {
        height:100%;
        width:{{line_width}}px;
      }

{% endif %}



{% if layout == "hv" %}

@media only screen and (max-width: {{responsive_breakpoint}}px) {
  #{{uc_id}}
    {
      flex-direction:column;
    }
  
  #{{uc_id}} .ue-step-item
  {
    flex-direction:row;
  }
  
  #{{uc_id}} .ue-item-highlight
  {
    flex-direction:column;
  }
  
   #{{uc_id}} .ue-step-item .ue-step-item-line:first-child
    {
      display:none;
    }
  

    #{{uc_id}}  .ue-step-item-gap:nth-child(2)
     {
      display:none;    
      }
   #{{uc_id}}  .ue-step-item-line:first-child
      {
      display:none;    
      }
  
    #{{uc_id}}  .ue-step-item-line
      {
        height:100%;
        width:{{line_width}}px;
      }
}

{% endif %}