<?php
namespace AvayeMarketing\AvaSlider\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit;

class CircularSlider extends Widget_Base {

    public function get_name() {
        return 'avaslider_circular';
    }

    public function get_title() {
        return __( 'اسلایدر دایره‌ای تعاملی', 'avaslider' );
    }

    public function get_icon() {
        return 'eicon-spinner';
    }

    public function get_categories() {
        return ['general'];
    }

    public function get_style_depends() {
        return ['avaslider-css'];
    }

    public function get_script_depends() {
        return ['avaslider-js'];
    }

    protected function register_controls() {

        $this->start_controls_section('items', [
            'label' => 'بخش‌ها'
        ]);

        $repeater = new Repeater();

        $repeater->add_control('title', [
            'label' => 'عنوان',
            'type' => Controls_Manager::TEXT,
            'default' => 'عنوان'
        ]);

        $repeater->add_control('color', [
            'label' => 'رنگ',
            'type' => Controls_Manager::COLOR,
            'default' => '#0F4C81'
        ]);

        $repeater->add_control('bg', [
            'label' => 'پس‌زمینه',
            'type' => Controls_Manager::MEDIA
        ]);

        $this->add_control('segments', [
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [], [], [], []
            ],
            'title_field' => '{{{ title }}}'
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="avaslider" data-count="<?php echo count($settings['segments']); ?>">
            <svg viewBox="0 0 200 200" class="avaslider__circle">
                <?php foreach ($settings['segments'] as $i => $seg): ?>
                    <circle cx="100" cy="100" r="80"
                        class="avaslider__segment"
                        data-bg="<?php echo esc_url($seg['bg']['url']); ?>"
                        style="stroke: <?php echo esc_attr($seg['color']); ?>;
                               stroke-dasharray: 125;
                               stroke-dashoffset: <?php echo $i * 125; ?>"/>
                <?php endforeach; ?>
            </svg>
            <div class="avaslider__content"></div>
        </div>
        <?php
    }
}
