<?php
defined('ABSPATH') || exit;

class Ava_MC_Admin_Media {

    private static array $taxonomies = ['category', 'service_category', 'portfolio_category'];

    public static function init(): void {
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_admin_assets']);
    }

    public static function enqueue_admin_assets(string $hook): void {
        if (!in_array($hook, ['edit-tags.php', 'term.php'], true)) {
            return;
        }

        $screen = function_exists('get_current_screen') ? get_current_screen() : null;
        if (!$screen || empty($screen->taxonomy) || !in_array($screen->taxonomy, self::$taxonomies, true)) {
            return;
        }

        wp_enqueue_media();

        $css = "
        .ava-mc-two-col{display:flex;gap:16px;align-items:flex-start;flex-wrap:wrap}
        .ava-mc-col{flex:1;min-width:240px}
        ";
        wp_register_style('ava-mc-inline', false);
        wp_enqueue_style('ava-mc-inline');
        wp_add_inline_style('ava-mc-inline', $css);

        $js = <<<JS
jQuery(function($){

  function setPreview(\$wrap, url){
    var \$preview = \$wrap.find('.ava-mc-preview');
    if(url){
      \$preview.html('<img src="'+url+'" style="max-width:220px;height:auto;border:1px solid #ddd;padding:4px;background:#fff;">');
      \$wrap.find('.ava-mc-remove').show();
    } else {
      \$preview.empty();
      \$wrap.find('.ava-mc-remove').hide();
    }
  }

  function setIconPreview(\$wrap, url){
    var \$preview = \$wrap.find('.ava-mc-icon-preview');
    if(url){
      \$preview.html('<img src="'+url+'" style="max-width:90px;height:auto;border:1px solid #ddd;padding:4px;background:#fff;">');
      \$wrap.find('.ava-mc-icon-remove').show();
    } else {
      \$preview.empty();
      \$wrap.find('.ava-mc-icon-remove').hide();
    }
  }

  $(document).on('click', '.ava-mc-upload', function(e){
    e.preventDefault();
    var \$wrap = $(this).closest('td, .form-field');

    var frame = wp.media({
      title: 'انتخاب تصویر',
      button: { text: 'انتخاب' },
      multiple: false
    });

    frame.on('select', function(){
      var att = frame.state().get('selection').first().toJSON();
      \$wrap.find('.ava-mc-image-id').val(att.id);

      var url = (att.sizes && att.sizes.medium) ? att.sizes.medium.url : att.url;
      setPreview(\$wrap, url);
    });

    frame.open();
  });

  $(document).on('click', '.ava-mc-remove', function(e){
    e.preventDefault();
    var \$wrap = $(this).closest('td, .form-field');
    \$wrap.find('.ava-mc-image-id').val('');
    setPreview(\$wrap, '');
  });

  $(document).on('click', '.ava-mc-icon-upload', function(e){
    e.preventDefault();
    var \$wrap = $(this).closest('td, .form-field');

    var frame = wp.media({
      title: 'انتخاب آیکون',
      button: { text: 'انتخاب' },
      multiple: false
    });

    frame.on('select', function(){
      var att = frame.state().get('selection').first().toJSON();
      \$wrap.find('.ava-mc-icon-id').val(att.id);

      var url = (att.sizes && att.sizes.thumbnail) ? att.sizes.thumbnail.url : att.url;
      setIconPreview(\$wrap, url);
    });

    frame.open();
  });

  $(document).on('click', '.ava-mc-icon-remove', function(e){
    e.preventDefault();
    var \$wrap = $(this).closest('td, .form-field');
    \$wrap.find('.ava-mc-icon-id').val('');
    setIconPreview(\$wrap, '');
  });

});
JS;

        wp_add_inline_script('jquery', $js);
    }
}

Ava_MC_Admin_Media::init();
