<?php
defined('ABSPATH') || exit;

add_action('init', function () {

    $labels = [
        'name'               => 'خدمات',
        'singular_name'      => 'خدمت',
        'menu_name'          => 'خدمات',
        'name_admin_bar'     => 'خدمت',
        'add_new'            => 'افزودن',
        'add_new_item'       => 'افزودن خدمت جدید',
        'new_item'           => 'خدمت جدید',
        'edit_item'          => 'ویرایش خدمت',
        'view_item'          => 'مشاهده خدمت',
        'all_items'          => 'همه خدمات',
        'search_items'       => 'جستجوی خدمات',
        'not_found'          => 'موردی یافت نشد.',
        'not_found_in_trash' => 'موردی در زباله‌دان یافت نشد.',
    ];

    register_post_type('services', [
        'labels'             => $labels,
        'public'             => true,
        'has_archive'        => true,
        'rewrite'            => ['slug' => 'services', 'with_front' => false],
        'menu_position'      => 20,
        'menu_icon'          => 'dashicons-megaphone',
        'supports'           => ['title', 'editor', 'thumbnail', 'excerpt', 'revisions'],
        'show_in_rest'       => true,
        'hierarchical'       => false,
        'publicly_queryable' => true,
        'exclude_from_search'=> false,
    ]);

    $tax_labels = [
        'name'              => 'دسته‌بندی خدمات',
        'singular_name'     => 'دسته خدمت',
        'search_items'      => 'جستجوی دسته‌ها',
        'all_items'         => 'همه دسته‌ها',
        'parent_item'       => 'دسته مادر',
        'parent_item_colon' => 'دسته مادر:',
        'edit_item'         => 'ویرایش دسته',
        'update_item'       => 'به‌روزرسانی دسته',
        'add_new_item'      => 'افزودن دسته جدید',
        'new_item_name'     => 'نام دسته جدید',
        'menu_name'         => 'دسته‌بندی خدمات',
    ];

    register_taxonomy('service_category', ['services'], [
        'labels'            => $tax_labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_admin_column' => true,
        'show_in_rest'      => true,
        'rewrite'           => ['slug' => 'services-category', 'with_front' => false],
    ]);

}, 0);
