<?php
defined('ABSPATH') || exit;

add_action('elementor/dynamic_tags/register', function($dynamic_tags){

    if ( ! class_exists('\Elementor\Core\DynamicTags\Tag') ) {
        return;
    }

    $dynamic_tags->register_group('ava_term_meta_group', [
        'title' => 'Ava Term Meta'
    ]);

    if ( ! function_exists('ava_mc_get_context_term_id') ) {
        function ava_mc_get_context_term_id(string $taxonomy, string $strategy = 'primary_then_first'): int {

            $obj = get_queried_object();
            if ($obj instanceof WP_Term && isset($obj->taxonomy) && $obj->taxonomy === $taxonomy) {
                return (int) $obj->term_id;
            }

            if (is_singular()) {
                $post_id = get_the_ID();
                if (!$post_id) return 0;

                $term_id = 0;

                if ($strategy === 'primary_then_first') {
                    $yoast_key = '_yoast_wpseo_primary_' . $taxonomy;
                    $yoast_primary = (int) get_post_meta($post_id, $yoast_key, true);
                    if ($yoast_primary > 0) $term_id = $yoast_primary;

                    if ($term_id <= 0) {
                        $rm_key_1 = 'rank_math_primary_' . $taxonomy;
                        $rm_key_2 = ($taxonomy === 'category') ? 'rank_math_primary_category' : '';
                        $rm_primary = (int) get_post_meta($post_id, $rm_key_1, true);
                        if ($rm_primary <= 0 && $rm_key_2) {
                            $rm_primary = (int) get_post_meta($post_id, $rm_key_2, true);
                        }
                        if ($rm_primary > 0) $term_id = $rm_primary;
                    }
                }

                if ($term_id <= 0) {
                    $terms = wp_get_post_terms($post_id, $taxonomy, ['fields' => 'ids']);
                    if (!is_wp_error($terms) && !empty($terms)) {
                        $term_id = (int) $terms[0];
                    }
                }

                return $term_id;
            }

            return 0;
        }
    }

    class Ava_MC_Term_Text_Tag extends \Elementor\Core\DynamicTags\Tag {

        public function get_name() { return 'ava_mc_term_text'; }
        public function get_title() { return 'Term Meta (Text)'; }
        public function get_group() { return 'ava_term_meta_group'; }
        public function get_categories() {
            return [ \Elementor\Modules\DynamicTags\Module::TEXT_CATEGORY ];
        }

        protected function register_controls() {
            $this->add_control('taxonomy', [
                'label' => 'Taxonomy Source',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'category' => 'category',
                    'service_category' => 'service_category',
                    'portfolio_category' => 'portfolio_category',
                ],
                'default' => 'service_category',
            ]);

            $this->add_control('strategy', [
                'label' => 'Single Strategy',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'primary_then_first' => 'Primary then First',
                    'first' => 'First Only',
                ],
                'default' => 'primary_then_first',
            ]);

            $this->add_control('meta_key', [
                'label' => 'Meta Field',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ava_marketing_title' => 'ava_marketing_title',
                    'ava_en_title'        => 'ava_en_title',
                ],
                'default' => 'ava_marketing_title',
            ]);
        }

        public function render() {
            $taxonomy = $this->get_settings('taxonomy') ?: 'service_category';
            $strategy = $this->get_settings('strategy') ?: 'primary_then_first';
            $term_id  = ava_mc_get_context_term_id($taxonomy, $strategy === 'first' ? 'first' : 'primary_then_first');
            if (!$term_id) return;

            $key = $this->get_settings('meta_key') ?: 'ava_marketing_title';
            $val = get_term_meta($term_id, $key, true);
            if (is_array($val)) $val = '';

            echo esc_html($val);
        }
    }

    class Ava_MC_Term_Image_Tag extends \Elementor\Core\DynamicTags\Tag {

        public function get_name() { return 'ava_mc_term_image'; }
        public function get_title() { return 'Term Meta (Image URL)'; }
        public function get_group() { return 'ava_term_meta_group'; }
        public function get_categories() {
            return [
                \Elementor\Modules\DynamicTags\Module::IMAGE_CATEGORY,
                \Elementor\Modules\DynamicTags\Module::URL_CATEGORY,
            ];
        }

        protected function register_controls() {
            $this->add_control('taxonomy', [
                'label' => 'Taxonomy Source',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'category' => 'category',
                    'service_category' => 'service_category',
                    'portfolio_category' => 'portfolio_category',
                ],
                'default' => 'service_category',
            ]);

            $this->add_control('strategy', [
                'label' => 'Single Strategy',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'primary_then_first' => 'Primary then First',
                    'first' => 'First Only',
                ],
                'default' => 'primary_then_first',
            ]);

            $this->add_control('image_field', [
                'label' => 'Image Field',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ava_image_id'      => 'ava_image_id',
                    'ava_icon_image_id' => 'ava_icon_image_id',
                ],
                'default' => 'ava_image_id',
            ]);

            $this->add_control('size', [
                'label' => 'Image Size',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'thumbnail' => 'thumbnail',
                    'medium'    => 'medium',
                    'large'     => 'large',
                    'full'      => 'full',
                ],
                'default' => 'large',
            ]);
        }

        public function get_value(array $options = []) {
            $taxonomy = $this->get_settings('taxonomy') ?: 'service_category';
            $strategy = $this->get_settings('strategy') ?: 'primary_then_first';
            $term_id  = ava_mc_get_context_term_id($taxonomy, $strategy === 'first' ? 'first' : 'primary_then_first');
            if (!$term_id) return [];

            $field    = $this->get_settings('image_field') ?: 'ava_image_id';
            $image_id = (int) get_term_meta($term_id, $field, true);
            if (!$image_id) return [];

            $size = $this->get_settings('size') ?: 'large';
            $url  = wp_get_attachment_image_url($image_id, $size);
            if (!$url) return [];

            return ['url' => $url, 'id' => $image_id];
        }

        public function render() {
            $val = $this->get_value();
            if (!empty($val['url'])) echo esc_url($val['url']);
        }
    }

    $dynamic_tags->register_tag('Ava_MC_Term_Text_Tag');
    $dynamic_tags->register_tag('Ava_MC_Term_Image_Tag');

}, 20);
