<?php
defined('ABSPATH') || exit;

function businesspro_enqueue_assets() {

    $main_css = get_template_directory() . '/assets/css/main.css';
    wp_enqueue_style(
        'businesspro-main',
        get_template_directory_uri() . '/assets/css/main.css',
        [],
        file_exists($main_css) ? filemtime($main_css) : '1.0.0'
    );

    // Optional webfont (can be removed if you use local fonts)
    wp_enqueue_style(
        'businesspro-peyda-font',
        'https://fonts.googleapis.com/css2?family=Peyda:wght@300;400;500;700&display=swap',
        [],
        null
    );

    if (is_rtl()) {
        $rtl_css = get_template_directory() . '/rtl.css';
        wp_enqueue_style(
            'businesspro-rtl',
            get_template_directory_uri() . '/rtl.css',
            ['businesspro-main'],
            file_exists($rtl_css) ? filemtime($rtl_css) : '1.0.0'
        );
    }

    $main_js = get_template_directory() . '/assets/js/scripts.js';
    wp_enqueue_script(
        'businesspro-scripts',
        get_template_directory_uri() . '/assets/js/scripts.js',
        [],
        file_exists($main_js) ? filemtime($main_js) : '1.0.0',
        true
    );

    wp_localize_script('businesspro-scripts', 'themeData', [
        'siteName' => get_bloginfo('name'),
        'siteUrl'  => home_url('/'),
    ]);
}

function businesspro_widgets_init() {
    register_sidebar([
        'name'          => __('سایدبار اصلی', 'businesspro'),
        'id'            => 'sidebar-1',
        'description'   => __('ابزارک‌های سایدبار', 'businesspro'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ]);
}
