<?php
defined('ABSPATH') || exit;

function businesspro_setup() {

    load_theme_textdomain('businesspro', get_template_directory() . '/languages');

    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');

    add_theme_support('custom-logo', [
        'height'      => 80,
        'width'       => 200,
        'flex-height' => true,
        'flex-width'  => true,
    ]);

    add_theme_support('post-thumbnails');

    add_theme_support('html5', [
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'style',
        'script',
    ]);

    add_theme_support('wp-block-styles');
    add_theme_support('align-wide');
    add_theme_support('responsive-embeds');

    // Elementor compatibility flags
    add_theme_support('elementor');
    add_theme_support('elementor-pro');

    register_nav_menus([
        'primary' => __('منوی اصلی', 'businesspro'),
    ]);

    // Content width
    if (!isset($GLOBALS['content_width'])) {
        $GLOBALS['content_width'] = 1200;
    }
}
