
(function($){
    $('.avaslider').each(function(){
        const slider = $(this);
        const segments = slider.find('.avaslider__segment');
        let index = 0;

        function activate(i){
            segments.removeClass('active');
            const seg = segments.eq(i).addClass('active');
            slider.find('.avaslider__content')
                .css('background-image', 'url(' + seg.data('bg') + ')');
        }

        activate(0);

        slider.on('wheel', function(e){
            e.preventDefault();
            index = (index + (e.originalEvent.deltaY > 0 ? 1 : -1) + segments.length) % segments.length;
            activate(index);
        });
    });
})(jQuery);
