<?php
// بارگذاری کتابخانه تقویم شمسی jdf.php
require_once get_template_directory() . '/vendor/jdf.php';

// تابع کمکی برای نمایش تاریخ شمسی در قالب
function the_jalali_date($format = 'j F Y') {
    echo jdate($format);
}

// تابع کوتاه برای استفاده در قالب‌ها
function get_jalali_date($format = 'Y/m/d') {
    return jdate($format);
}

// Theme wrapper: output Jalali date for current post when inside the loop
function businesspro_the_date($format = 'Y/m/d') {
    if (function_exists('get_the_date')) {
        // jdate() uses current timestamp; use WP post timestamp if available
        $ts = get_the_time('U');
        echo esc_html( jdate($format, $ts) );
        return;
    }
    echo esc_html( jdate($format) );
}

function businesspro_get_date($format = 'Y/m/d') {
    $ts = get_the_time('U');
    return esc_html( jdate($format, $ts) );
}
